
#ifndef __GRPTag_h
#define __GRPTag_h

#include "GrphclRp\GrphclOb\GRTag.h"


// this class is used, to determine, when
// a position tag ends. The endposition 
// is the position within the voice.
// when this position has been parsed
// in the GRVoiceManager, then we know, that
// the positiontag-range has ended.

// the GRPositionTag also has a list of 
// staffs, start- and endelements aswell
// as a void-pointer that is used to handle
// position tags that reach over multiple systems)
// (that is, that they have been broken either by
// newSystem/newPage or by automatic Break-routines).

#include "kf_ilist.h"

class GRSystem;
// class GRSystemSlice;
class GRNotationElement;


class GRSystemStartEndStruct
{
public:

	enum setflag { LEFTMOST, RIGHTMOST,
		OPENLEFT, OPENRIGHT ,NOTKNOWN };
		

	GRSystemStartEndStruct()
	{
		grsystem = NULL;
		startElement = NULL;
		endElement = NULL;
		startflag = NOTKNOWN;
		endflag = NOTKNOWN;
		p = NULL;
		startpos = NULL;
		endpos = NULL;
	}
	virtual ~GRSystemStartEndStruct();

	GRSystem *grsystem;

	GRNotationElement *startElement;
	GRNotationElement *endElement;

	setflag startflag;
	setflag endflag;


	// these give the position
	// in the associated lists ...
	// so that the tag later nows, where it's sub
	// -parts start and end.
	POSITION startpos;
	POSITION endpos;

	void *p;
};

typedef KF_IPointerList<GRSystemStartEndStruct> SSEList;

// the position tag owns this list.

class GRPositionTag : public GRTag
{
public:
	class GRSaveStruct 
	{
	public:
		GRSaveStruct() {};
		virtual ~GRSaveStruct() {};
	};
public:
	void DeleteAllSSEs();
	virtual void ResumeTag(GRStaff *grstaff,POSITION assocpos);
	virtual void BreakTag(GRStaff *grstaff,POSITION &assocpos);
	virtual void StaffBegin(GRStaff *grstaff = NULL);
	virtual void StaffFinished(GRStaff *grstaff = NULL);
	virtual void RangeEnd(GRStaff *grstaff = NULL);

	void changeCurrentSystem(GRSystem *psystem);
	virtual int DeleteStaff(GRStaff *grstaff);
	GRPositionTag(ARMusicalTag *armt = NULL);
	GRPositionTag(POSITION p_ep,ARMusicalTag *armt = NULL);

	POSITION getEndPos(void) const 
	{
		return ep;
	}

	GRSystemStartEndStruct * 
		getSystemStartEndStruct(const GRSystem *grsystem) const;

protected:
	POSITION ep;

	// the Staff-Start-End-List
	SSEList sselist;

	GRSystemStartEndStruct::setflag lastendflag;
	GRNotationElement *lastendElement;
	POSITION lastendpos;

	virtual void setStartElement(const GRStaff *grstaff,
		GRNotationElement *n_element);
	virtual void setEndElement(const GRStaff *grstaff,
		GRNotationElement *n_element);

	virtual void addAssociation(GRNotationElement *grnot);
	virtual void removeAssociation(GRNotationElement *grnot);

	virtual GRPositionTag::GRSaveStruct * 
		getNewGRSaveStruct() 
	{ 
		return new GRSaveStruct();
	}
};


#endif
